//
//  GSVideoViewController+PIPController.m
//  PlayerSDKDemo
//
//  Created by 230222 on 2025/12/18.
//  Copyright © 2025 Geensee. All rights reserved.
//

#import "GSVideoViewController+PIPController.h"

@implementation GSVideoViewController (PIPController)
- (void)startPIPControllerManager{
    if (![AVPictureInPictureController isPictureInPictureSupported]) {
        NSLog(@"不支持画中画");
        return;
    }
    self.pipShowDoc = NO;
    self.pipShowVideo = NO;
    
    self.videoView.delegate = self;
    self.videoView.enableRenderImage = NO;
    
    UIButton * videoPipButton = [UIButton buttonWithType:UIButtonTypeSystem];
    videoPipButton.frame = CGRectMake(self.videoView.frame.size.width - 100, self.videoView.frame.size.height -60, 100, 50);
    [videoPipButton setTitle:@"开启视频画中画" forState:UIControlStateNormal];
    [videoPipButton setTitle:@"关闭视频画中画" forState:UIControlStateSelected];
    videoPipButton.titleLabel.adjustsFontSizeToFitWidth = YES;
    [videoPipButton addTarget:self action:@selector(startVideoPIP:) forControlEvents:UIControlEventTouchUpInside];
    [self.videoView addSubview:videoPipButton];
    self.videoPipButton = videoPipButton;
    
    UIButton * docPipButton = [UIButton buttonWithType:UIButtonTypeSystem];
    docPipButton.frame = CGRectMake(self.docView.frame.size.width - 100, self.docView.frame.size.height -60, 100, 50);
    [docPipButton setTitle:@"开启文档画中画" forState:UIControlStateNormal];
    [docPipButton setTitle:@"关闭文档画中画" forState:UIControlStateSelected];
    docPipButton.titleLabel.adjustsFontSizeToFitWidth = YES;
    [docPipButton addTarget:self action:@selector(startDocPIP:) forControlEvents:UIControlEventTouchUpInside];
    [self.docView addSubview:docPipButton];
    self.docPipButton = docPipButton;
    
    
    self.pipControllerManager = [[GSPipControllerManager alloc] initWith:self.view];
    self.pipControllerManager.delegate = self;

}
#pragma mark -- 开启视频画中画
- (void)startVideoPIP:(UIButton *)sender{
    sender.selected = !sender.selected;
    self.pipShowDoc = NO;
    self.docPipButton.selected = NO;
    
    if(sender.selected){
        self.pipShowVideo = YES;
        self.videoView.enableRenderImage = YES;
        [self.pipControllerManager setPlayerLayerFrame:self.videoArea.frame];
        [self.pipControllerManager startPip];
    }else{
        self.pipShowVideo = NO;
        self.videoView.enableRenderImage = NO;
        [self stopPIPControllerManager];
    }
}
#pragma mark -- 开启文档画中画
- (void)startDocPIP:(UIButton *)sender{
    sender.selected = !sender.selected;
    self.pipShowVideo = NO;
    self.videoPipButton.selected = NO;
    self.videoView.enableRenderImage = NO;

    if(sender.selected){
        self.pipShowDoc = YES;
        [self.pipControllerManager setPlayerLayerFrame:self.docArea.frame];
        // 开启画中画，主动获取文档当前渲染的图片
        [self.manager getDocPageAndAnnoRenderImage];
        [self.pipControllerManager startPip];

    }else{
        self.pipShowDoc = NO;
        [self stopPIPControllerManager];
    }
}
#pragma mark -- 关闭画中画
- (void)stopPIPControllerManager {
    if(self.pipControllerManager){
        [self.pipControllerManager stopPip];
    }
}
#pragma mark -- 画中画关闭回调
- (void)pipControllerDidStop{
    if(self.pipShowDoc){
        self.pipShowDoc = NO;
        self.docPipButton.selected = NO;
    }
    if(self.pipShowVideo){
        self.pipShowVideo = NO;
        self.videoPipButton.selected = NO;
        self.videoView.enableRenderImage = NO;
    }
}
#pragma mark -- 收到文档回调
- (void)playerManager:(GSPPlayerManager *)playerManager timeStamp:(NSInteger)timeStamp width:(NSInteger)width height:(NSInteger)height{
    if(self.pipShowDoc){
        /// 当文档内容发生改变时，获取文档内容和批注渲染的图片
        [self.manager getDocPageAndAnnoRenderImage];
    }
}
#pragma mark -- 收到文档批注回调
- (void)playerManager:(GSPPlayerManager *)playerManager annoTimeStamp:(NSInteger)timeStamp{
    if(self.pipShowDoc){
        /// 当文档批注发生改变时，获取文档内容和批注渲染的图片
        [self.manager getDocPageAndAnnoRenderImage];
    }
}
#pragma mark -- 收到获取文档内容和批注渲染的图片
- (void)playerManager:(GSPPlayerManager *)playerManager docPageAndAnnoRenderImage:(CIImage *)renderImage{
    if(self.pipShowDoc){
        [self.pipControllerManager resetPlaceholderCIImage:renderImage];
    }
}
#pragma mark -- 视频代理回调 - 当前渲染的image
- (void)videoView:(GSPVideoView *)videoView currentRenderImage:(UIImage *)renderImage{
    if(self.pipShowVideo){
        [self.pipControllerManager resetPlaceholderCIImage:[CIImage imageWithCGImage:renderImage.CGImage]];
    }
}

@end
